'use client'

import { useState } from 'react'
import { ChevronLeft, ChevronRight, Facebook, Instagram, Linkedin, Star, MessageSquare, X, Briefcase, HandshakeIcon, FileText, Globe, Youtube } from 'lucide-react'
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Textarea } from "@/components/ui/textarea"
import Link from 'next/link'

function BottomSheet({ isOpen, onClose, title, children }) {
  if (!isOpen) return null;
  return (
    <div className="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-end justify-center animate-fade-in">
      <div className="bg-white rounded-t-2xl w-full max-h-[90vh] overflow-y-auto animate-slide-up">
        <div className="sticky top-0 bg-white border-b px-4 py-3 flex flex-col items-center">
          <div className="w-12 h-1 bg-gray-300 rounded-full mb-3" />
          <h3 className="text-lg font-semibold">{title}</h3>
          <button 
            onClick={onClose} 
            className="absolute right-4 top-4 p-1 rounded-full hover:bg-gray-100"
          >
            <X className="h-5 w-5 text-gray-500" />
          </button>
        </div>
        <div className="p-4">
          {children}
        </div>
      </div>
    </div>
  );
}

export function BlockPage() {
  const [activePopup, setActivePopup] = useState(null);

  const popupContent = {
    jobs: {
      title: "Offres d'emploi",
      content: (
        <div className="space-y-4">
          <p className="text-gray-600">Rejoignez notre équipe dynamique et contribuez à révolutionner la gestion immobilière !</p>
          <h4 className="font-semibold text-gray-800">Postes ouverts :</h4>
          <ul className="list-disc pl-5 text-gray-600">
            <li>Développeur Full Stack</li>
            <li>Designer UX/UI</li>
            <li>Responsable Marketing Digital</li>
            <li>Expert en Immobilier</li>
          </ul>
          <p className="text-gray-600">Pour postuler, envoyez votre CV à <a href="mailto:careers@casaok.com" className="text-purple-600 underline hover:text-purple-700">careers@casaok.com</a></p>
        </div>
      )
    },
    partner: {
      title: "Devenir partenaire",
      content: (
        <div className="space-y-4">
          <p className="text-gray-600">Devenez partenaire de CasaOK et développez votre activité tout en offrant une solution innovante à vos clients.</p>
          <h4 className="font-semibold text-gray-800">Avantages du partenariat :</h4>
          <ul className="list-disc pl-5 text-gray-600">
            <li>Accès à notre technologie de pointe</li>
            <li>Support dédié</li>
            <li>Commissions attractives</li>
            <li>Formation continue</li>
          </ul>
          <p className="text-gray-600">Intéressé ? Contactez-nous à <a href="mailto:partnerships@casaok.com" className="text-purple-600 underline hover:text-purple-700">partnerships@casaok.com</a></p>
        </div>
      )
    },
    terms: {
      title: "Conditions d'utilisation",
      content: (
        <div className="space-y-4">
          <p className="text-gray-600">En utilisant CasaOK, vous acceptez nos conditions d'utilisation. Voici les points clés :</p>
          <ul className="list-disc pl-5 text-gray-600">
            <li>Respect de la confidentialité des données</li>
            <li>Utilisation équitable de la plateforme</li>
            <li>Responsabilités des utilisateurs</li>
            <li>Procédures de résolution des litiges</li>
          </ul>
          <p className="text-gray-600">Pour lire l'intégralité des conditions, visitez <a href="https://casaok.com/terms" className="text-purple-600 underline hover:text-purple-700">notre page des conditions d'utilisation</a>.</p>
        </div>
      )
    },
    feedback: {
      title: "Donnez votre avis",
      content: (
        <div className="space-y-4">
          <p className="text-gray-600">Votre avis est précieux pour nous aider à améliorer CasaOK. Partagez vos commentaires :</p>
          <Textarea placeholder="Entrez votre feedback ici..." rows={4} className="w-full" />
          <Button className="w-full bg-purple-600 text-white hover:bg-purple-700">Envoyer le feedback</Button>
        </div>
      )
    },
    rate: {
      title: "Noter l'application",
      content: (
        <div className="space-y-4">
          <p className="text-gray-600">Aimez-vous CasaOK ? Votre évaluation nous aide à grandir !</p>
          <div className="flex justify-center">
            {[1, 2, 3, 4, 5].map((star) => (
              <Star key={star} className="h-8 w-8 text-yellow-400" />
            ))}
          </div>
          <Button className="w-full bg-purple-600 text-white hover:bg-purple-700">Noter sur l'App Store</Button>
          <Button className="w-full mt-2 bg-purple-600 text-white hover:bg-purple-700">Noter sur Google Play</Button>
        </div>
      )
    },
  };

  return (
    <div className="flex flex-col min-h-screen bg-gray-100">
      <header className="sticky top-0 z-10 bg-white border-b">
        <div className="flex items-center justify-between px-4 py-3">
          <Link href="/">
            <Button variant="ghost" size="icon">
              <ChevronLeft className="h-6 w-6" />
            </Button>
          </Link>
          <h1 className="text-base font-semibold">À propos</h1>
          <div className="w-10"></div>
        </div>
      </header>

      <main className="flex-1 overflow-y-auto p-3 space-y-3">
        <Card>
          <CardHeader className="pb-2">
            <CardTitle className="text-lg">Notre Mission</CardTitle>
          </CardHeader>
          <CardContent className="pt-0">
            <p>Simplifier la gestion immobilière pour les propriétaires grâce à la technologie, rendant le processus plus efficace et transparent.</p>
          </CardContent>
        </Card>

        <Card>
          <CardHeader className="pb-2">
            <CardTitle className="text-lg">Nos Valeurs</CardTitle>
          </CardHeader>
          <CardContent className="pt-0 space-y-4">
            {[
              { title: "Innovation", description: "Repousser les limites technologiques", icon: "🚀" },
              { title: "Transparence", description: "Communication ouverte et honnête", icon: "🔍" },
              { title: "Fiabilité", description: "Service cohérent et de haute qualité", icon: "🛡️" }
            ].map((value, index) => (
              <div key={index} className="flex items-center space-x-2">
                <div className="bg-purple-100 rounded-full p-1.5">
                  <span className="text-xl">{value.icon}</span>
                </div>
                <div>
                  <h3 className="font-semibold text-sm">{value.title}</h3>
                  <p className="text-xs text-gray-600">{value.description}</p>
                </div>
              </div>
            ))}
          </CardContent>
        </Card>

        <Card>
          <CardContent className="p-0">
            {[
              { title: "Offres d'emploi", id: "jobs", icon: Briefcase },
              { title: "Partenaire", id: "partner", icon: HandshakeIcon },
              { title: "Conditions d'utilisation", id: "terms", icon: FileText },
              { title: "Feedback", id: "feedback", icon: MessageSquare },
              { title: "Noter l'application", id: "rate", icon: Star },
              { title: "Visiter notre site", href: "https://casaok.com", icon: Globe },
            ].map((item, index) => (
              <button 
                key={index} 
                className="flex items-center justify-between w-full py-3 px-4 hover:bg-gray-50 border-b last:border-b-0"
                onClick={() => item.href ? window.open(item.href, '_blank') : setActivePopup(item.id)}
              >
                <div className="flex items-center space-x-3">
                  <item.icon className="h-5 w-5 text-purple-600" />
                  <span>{item.title}</span>
                </div>
                <ChevronRight className="h-5 w-5 text-gray-400" />
              </button>
            ))}
          </CardContent>
        </Card>

        <Card>
          <CardHeader className="pb-2">
            <CardTitle className="text-lg">Suivez-nous</CardTitle>
          </CardHeader>
          <CardContent>
            <div className="grid grid-cols-3 gap-4">
              {[
                { icon: Facebook, href: "https://facebook.com/casaok" },
                { icon: Instagram, href: "https://instagram.com/casaok" },
                { icon: Linkedin, href: "https://linkedin.com/company/casaok" },
                { icon: Youtube, href: "https://youtube.com/casaok" },
                { icon: X, href: "https://x.com/casaok" },
                { icon: Globe, href: "https://casaok.com" },
              ].map((item, index) => (
                <a 
                  key={index}
                  href={item.href}
                  className="bg-purple-100 p-3 rounded-lg hover:bg-purple-200 transition-colors flex items-center justify-center"
                >
                  <item.icon className="h-5 w-5 text-purple-600" />
                </a>
              ))}
            </div>
          </CardContent>
        </Card>
      </main>

      <BottomSheet
        isOpen={!!activePopup}
        onClose={() => setActivePopup(null)}
        title={activePopup ? popupContent[activePopup].title : ''}
      >
        {activePopup && popupContent[activePopup].content}
      </BottomSheet>

      <footer className="bg-white border-t py-3 px-4 text-center text-xs text-gray-500">
        <p className="font-semibold">Version 1.2.1</p>
        <p className="mt-1">© 2024 CasaOK. Tous droits réservés.</p>
      </footer>
    </div>
  )
}