'use client'

import {useState} from 'react'
import {useRouter} from 'next/navigation'
import {Button} from "@/components/ui/button"
import {Card, CardContent} from "@/components/ui/card"
import {AlertTriangle, Bell, Building, Calendar, ChevronRight, ClipboardCheck, PlusCircle} from 'lucide-react'

export function BlockPage() {
    const [userName] = useState('John Doe')
    const router = useRouter()

    const recentActivity = [
        {id: 1, text: 'Inspection complétée pour Appartement Paris', date: '1 Juin 2024'},
        {id: 2, text: 'Nouvelle inspection planifiée pour Maison Bordeaux', date: '15 Mai 2024'},
        {id: 3, text: 'Rapport d\'inspection reçu pour Studio Lyon', date: '1 Mai 2024'},
    ]

    return (
        <div className="min-h-screen bg-gray-50 pb-16">
            <header className="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-10">
                <div className="flex items-center">
                    <Building className="h-6 w-6 text-[#8B5CF6]"/>
                    <h1 className="ml-2 text-lg font-bold text-gray-900">CasaOK</h1>
                </div>
                <div className="flex items-center space-x-4">
                    <button className="relative p-2 bg-gray-100 rounded-full"
                            onClick={() => router.push('/notifications')}>
                        <Bell className="h-5 w-5 text-gray-600"/>
                        <span
                            className="absolute top-0 right-0 h-2 w-2 bg-red-500 rounded-full border-2 border-white"></span>
                    </button>
                </div>
            </header>

            <main className="p-4 max-w-md mx-auto">
                <div className="space-y-1 mb-6">
                    <h1 className="text-2xl font-bold text-gray-900">Bonjour, {userName}</h1>
                    <p className="text-base text-gray-500">Bienvenue sur votre tableau de bord</p>
                </div>

                <div className="grid grid-cols-2 gap-4 mb-6">
                    <Card className="bg-white rounded-xl shadow-sm">
                        <CardContent className="p-4 space-y-4">
                            <div className="space-y-2">
                                <h2 className="text-lg font-bold text-gray-900">Dernière inspection</h2>
                                <div className="space-y-1">
                                    <p className="text-sm text-gray-500">1 Juin 2024</p>
                                    <p className="text-sm text-gray-900 font-medium">Appartement Paris</p>
                                    <p className="text-sm text-green-500">Complétée</p>
                                </div>
                            </div>
                            <Button
                                className="w-full bg-[#8B5CF6] hover:bg-[#7C3AED] text-white h-10 text-xs rounded-lg"
                                onClick={() => router.push('/inspections/last')}
                            >
                                <ClipboardCheck className="mr-1 h-4 w-4"/>
                                Voir détails
                            </Button>
                        </CardContent>
                    </Card>

                    <Card className="bg-white rounded-xl shadow-sm">
                        <CardContent className="p-4 space-y-4">
                            <div className="space-y-2">
                                <h2 className="text-lg font-bold text-gray-900">Nouvelle inspection</h2>
                                <p className="text-sm text-gray-500">Planifiez votre prochaine inspection</p>
                            </div>
                            <Button
                                className="w-full bg-[#8B5CF6] hover:bg-[#7C3AED] text-white h-10 text-xs rounded-lg"
                                onClick={() => router.push('/inspections/new')}
                            >
                                <Calendar className="mr-1 h-4 w-4"/>
                                Planifier
                            </Button>
                        </CardContent>
                    </Card>
                </div>

                <Card className="bg-white rounded-xl shadow-sm mb-6">
                    <CardContent className="p-4">
                        <div className="flex justify-between items-center mb-4">
                            <h2 className="text-lg font-bold text-gray-900">Vos propriétés</h2>
                            <span className="text-2xl font-bold text-[#8B5CF6]">5</span>
                        </div>
                        <Button
                            variant="outline"
                            className="w-full border-[#8B5CF6] text-[#8B5CF6] hover:bg-[#8B5CF6] hover:text-white rounded-lg"
                            onClick={() => router.push('/settings/properties')}
                        >
                            Gérer mes propriétés
                        </Button>
                    </CardContent>
                </Card>

                <Card className="bg-red-50 border-red-200 rounded-xl shadow-sm mb-6">
                    <CardContent className="p-4 space-y-4">
                        <div className="flex items-center space-x-2">
                            <AlertTriangle className="h-6 w-6 text-red-500"/>
                            <h2 className="text-lg font-bold text-red-700">Action requise</h2>
                        </div>
                        <p className="text-sm text-red-600">Des documents importants pour vos propriétés sont
                            incomplets. Veuillez les compléter dès que possible.</p>
                        <Button
                            className="w-full bg-red-600 hover:bg-red-700 text-white h-10 text-xs rounded-lg"
                            onClick={() => router.push('/settings/properties/1/documents')}
                        >
                            <ClipboardCheck className="mr-1 h-4 w-4"/>
                            Compléter les documents (Obligatoire)
                        </Button>
                    </CardContent>
                </Card>

                <Card className="bg-white rounded-xl shadow-sm mb-6">
                    <CardContent className="p-4">
                        <h2 className="text-lg font-bold text-gray-900 mb-4">Activité récente</h2>
                        <ul className="space-y-3">
                            {recentActivity.map((activity) => (
                                <li key={activity.id} className="flex items-center space-x-3">
                                    <div className="flex-shrink-0 w-2 h-2 bg-[#8B5CF6] rounded-full"></div>
                                    <div>
                                        <p className="text-sm text-gray-900">{activity.text}</p>
                                        <p className="text-xs text-gray-500">{activity.date}</p>
                                    </div>
                                </li>
                            ))}
                        </ul>
                        <Button
                            variant="link"
                            className="w-full text-[#8B5CF6] mt-4"
                            onClick={() => router.push('/activity')}
                        >
                            Voir toute l'activité
                            <ChevronRight className="ml-1 h-4 w-4"/>
                        </Button>
                    </CardContent>
                </Card>

                <div className="space-y-2 mb-6">
                    <Button
                        className="w-full bg-[#8B5CF6] hover:bg-[#7C3AED] text-white h-10 text-sm rounded-lg"
                        onClick={() => router.push('/properties/new')}
                    >
                        <PlusCircle className="mr-2 h-4 w-4"/>
                        Ajouter une propriété
                    </Button>
                    <Button
                        variant="outline"
                        className="w-full border-[#8B5CF6] text-[#8B5CF6] hover:bg-[#8B5CF6] hover:text-white h-10 text-sm rounded-lg"
                        onClick={() => router.push('/inspections/new')}
                    >
                        <Calendar className="mr-2 h-4 w-4"/>
                        Planifier une inspection
                    </Button>
                </div>
            </main>


        </div>
    )
}