'use client'

import { useState } from 'react'
import { ChevronLeft, ChevronDown, ChevronUp, Search } from 'lucide-react'
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import Link from 'next/link'

type FAQSection = {
  title: string;
  items: FAQItem[];
}

type FAQItem = {
  question: string;
  answer: string;
}

const faqSections: FAQSection[] = [
  {
    title: "Général",
    items: [
      {
        question: "Qu'est-ce que CasaOK Propriétaire ?",
        answer: "CasaOK Propriétaire est une application mobile conçue pour aider les propriétaires à gérer efficacement leurs biens immobiliers, en facilitant les inspections, la communication avec les locataires et le suivi des paiements."
      },
      {
        question: "Comment puis-je contacter le support client ?",
        answer: "Vous pouvez contacter notre support client via l'option 'Aide & Support' dans le menu de l'application. Vous pouvez également nous envoyer un e-mail à support@casaok.com ou nous appeler au 01 23 45 67 89 pendant nos heures d'ouverture."
      },
      {
        question: "CasaOK Propriétaire est-il disponible sur iOS et Android ?",
        answer: "Oui, CasaOK Propriétaire est disponible à la fois sur iOS (App Store) et Android (Google Play Store)."
      },
      {
        question: "L'application est-elle gratuite ?",
        answer: "CasaOK Propriétaire propose une version gratuite avec des fonctionnalités de base. Des fonctionnalités premium sont disponibles via un abonnement payant."
      },
      {
        question: "Puis-je utiliser CasaOK Propriétaire sur mon ordinateur ?",
        answer: "Actuellement, CasaOK Propriétaire est une application mobile. Cependant, nous travaillons sur une version web qui sera bientôt disponible."
      }
    ]
  },
  {
    title: "Compte",
    items: [
      {
        question: "Comment créer un compte ?",
        answer: "Pour créer un compte, téléchargez l'application CasaOK Propriétaire, cliquez sur 'S'inscrire' et suivez les étapes pour remplir vos informations personnelles."
      },
      {
        question: "Comment réinitialiser mon mot de passe ?",
        answer: "Dans l'écran de connexion, cliquez sur 'Mot de passe oublié' et suivez les instructions envoyées à votre adresse e-mail pour réinitialiser votre mot de passe."
      },
      {
        question: "Puis-je avoir plusieurs comptes liés à la même adresse e-mail ?",
        answer: "Non, chaque compte doit avoir une adresse e-mail unique. Cependant, vous pouvez gérer plusieurs propriétés avec un seul compte."
      },
      {
        question: "Comment puis-je modifier mes informations personnelles ?",
        answer: "Allez dans 'Paramètres' > 'Profil' pour modifier vos informations personnelles telles que votre nom, numéro de téléphone ou adresse."
      },
      {
        question: "Comment supprimer mon compte ?",
        answer: "Pour supprimer votre compte, allez dans 'Paramètres' > 'Compte' > 'Supprimer le compte'. Notez que cette action est irréversible et supprimera toutes vos données."
      }
    ]
  },
  {
    title: "Gestion des biens",
    items: [
      {
        question: "Comment ajouter un nouveau bien immobilier ?",
        answer: "Dans le menu principal, sélectionnez 'Mes biens' puis cliquez sur le bouton '+'. Remplissez les détails du bien et sauvegardez."
      },
      {
        question: "Puis-je gérer plusieurs propriétés avec CasaOK Propriétaire ?",
        answer: "Oui, vous pouvez gérer autant de propriétés que vous le souhaitez avec un seul compte CasaOK Propriétaire."
      },
      {
        question: "Comment modifier les informations d'un bien ?",
        answer: "Sélectionnez le bien dans 'Mes biens', puis cliquez sur 'Modifier' pour changer les détails du bien."
      },
      {
        question: "Puis-je supprimer un bien de mon compte ?",
        answer: "Oui, vous pouvez supprimer un bien en allant dans les détails du bien et en sélectionnant 'Supprimer'. Attention, cette action est irréversible."
      },
      {
        question: "Comment ajouter des photos à mes biens ?",
        answer: "Dans les détails du bien, sélectionnez 'Ajouter des photos' et choisissez les images depuis votre galerie ou prenez de nouvelles photos."
      }
    ]
  },
  {
    title: "Inspections",
    items: [
      {
        question: "Comment programmer une inspection ?",
        answer: "Dans la section 'Inspections', cliquez sur 'Nouvelle inspection', sélectionnez le bien concerné, le type d'inspection, et choisissez une date et une heure."
      },
      {
        question: "Quels types d'inspections CasaOK propose-t-il ?",
        answer: "CasaOK propose des états des lieux d'entrée et de sortie, des inspections de routine, des inspections avant achat, et des inspections de conformité pour les locaux commerciaux."
      },
      {
        question: "Puis-je modifier ou annuler une inspection programmée ?",
        answer: "Oui, vous pouvez modifier ou annuler une inspection jusqu'à 24 heures avant l'heure prévue. Allez dans 'Mes inspections' et sélectionnez l'inspection concernée."
      },
      {
        question: "Comment accéder aux rapports d'inspection ?",
        answer: "Les rapports d'inspection sont disponibles dans la section 'Rapports' de l'application. Vous pouvez les consulter, les télécharger ou les partager directement depuis l'app."
      },
      {
        question: "Les inspecteurs sont-ils certifiés ?",
        answer: "Oui, tous nos inspecteurs sont certifiés et formés selon les normes les plus strictes du secteur immobilier."
      }
    ]
  },
  {
    title: "Paiement",
    items: [
      {
        question: "Comment sont gérés les paiements ?",
        answer: "Les paiements sont gérés de manière sécurisée via notre système intégré. Vous pouvez ajouter plusieurs méthodes de paiement, voir l'historique de vos transactions et télécharger vos factures directement depuis l'application."
      },
      {
        question: "Quels sont les moyens de paiement acceptés ?",
        answer: "Nous acceptons les cartes bancaires principales (Visa, Mastercard) ainsi que les virements bancaires SEPA."
      },
      {
        question: "Les paiements sont-ils sécurisés ?",
        answer: "Oui, nous utilisons un cryptage de bout en bout et respectons les normes PCI DSS pour garantir la sécurité de vos informations de paiement."
      },
      {
        question: "Puis-je configurer des paiements récurrents ?",
        answer: "Oui, vous pouvez configurer des paiements récurrents pour les services réguliers comme les inspections de routine."
      },
      {
        question: "Comment puis-je obtenir un remboursement ?",
        answer: "Pour demander un remboursement, contactez notre service client via l'application ou par e-mail à support@casaok.com. Chaque demande est traitée au cas par cas."
      }
    ]
  },
  {
    title: "Facturation",
    items: [
      {
        question: "Comment obtenir mes factures ?",
        answer: "Vos factures sont disponibles dans la section 'Facturation' de votre compte. Vous pouvez les télécharger au format PDF à tout moment."
      },
      {
        question: "Quels sont les tarifs ?",
        answer: "Nos tarifs varient selon le type d'inspection et la localisation. Consultez la grille tarifaire dans l'application pour plus de détails."
      },
      {
        question: "La TVA est-elle incluse dans les prix affichés ?",
        answer: "Oui, tous nos prix affichés incluent la TVA applicable."
      },
      {
        question: "Puis-je obtenir une facture au nom de ma société ?",
        answer: "Oui, vous pouvez configurer les détails de facturation de votre société dans la section 'Paramètres de facturation' de votre compte."
      },
      {
        question: "Quelle est la fréquence de facturation pour l'abonnement premium ?",
        answer: "L'abonnement premium est facturé mensuellement ou annuellement, selon l'option que vous choisissez. Vous pouvez modifier votre plan à tout moment."
      }
    ]
  },
  {
    title: "Confidentialité et sécurité",
    items: [
      {
        question: "Comment CasaOK protège-t-il mes données personnelles ?",
        answer: "CasaOK utilise un cryptage de bout en bout pour protéger vos données. Nous ne partageons jamais vos informations avec des tiers sans votre consentement explicite."
      },
      {
        question: "Puis-je supprimer mon compte et toutes mes données ?",
        answer: "Oui, vous pouvez supprimer votre compte et toutes vos données associées à tout moment. Allez dans 'Paramètres' > 'Confidentialité' et suivez les instructions pour la suppression du compte."
      },
      {
        question: "CasaOK est-il conforme au RGPD ?",
        answer: "Oui, CasaOK est entièrement conforme au Règlement Général sur la Protection des Données (RGPD) de l'Union Européenne."
      },
      {
        question: "Comment puis-je gérer mes préférences de confidentialité ?",
        answer: "Vous pouvez gérer vos préférences de confidentialité, y compris les autorisations de l'application et les paramètres de notification, dans la section 'Paramètres' > 'Confidentialité'."
      },
      {
        question: "Mes données sont-elles partagées avec des tiers ?",
        answer: "Nous ne partageons vos données avec des tiers que lorsque cela est nécessaire pour fournir nos services (par exemple, avec les inspecteurs pour les rendez-vous) ou si la loi l'exige. Consultez notre politique de confidentialité pour plus de détails."
      }
    ]
  }
]

export function BlockPage() {
  const [openItems, setOpenItems] = useState<number[]>([])
  const [activeSection, setActiveSection] = useState("Général")
  const [searchQuery, setSearchQuery] = useState("")

  const toggleItem = (index: number) => {
    setOpenItems(prev => 
      prev.includes(index) 
        ? prev.filter(i => i !== index)
        : [...prev, index]
    )
  }

  const filteredSection = faqSections.find(section => section.title === activeSection) || faqSections[0]
  const filteredItems = filteredSection.items.filter(item => 
    item.question.toLowerCase().includes(searchQuery.toLowerCase()) ||
    item.answer.toLowerCase().includes(searchQuery.toLowerCase())
  )

  return (
    <div className="min-h-screen bg-white">
      <div className="sticky top-0 z-10 bg-white">
        <div className="px-4 py-3 border-b">
          <div className="flex items-center justify-between max-w-md mx-auto">
            <Link href="/settings">
              <Button variant="ghost" size="icon" className="text-gray-600 hover:text-gray-900">
                <ChevronLeft className="h-5 w-5" />
                <span className="sr-only">Retour</span>
              </Button>
            </Link>
            <h1 className="text-lg font-semibold text-gray-900">FAQ</h1>
            <div className="w-8"></div>
          </div>
        </div>
        
        <div className="px-4 py-3 space-y-3 bg-gray-50/80 backdrop-blur-sm">
          <div className="relative max-w-md mx-auto">
            <Search className="absolute left-3 top-2.5 h-4 w-4 text-gray-400" />
            <Input
              type="search"
              placeholder="Rechercher"
              className="pl-9 bg-white"
              value={searchQuery}
              onChange={(e) => setSearchQuery(e.target.value)}
            />
          </div>
          
          <div className="flex overflow-x-auto gap-2 pb-2 max-w-md mx-auto">
            {faqSections.map((section) => (
              <button
                key={section.title}
                onClick={() => setActiveSection(section.title)}
                className={`px-4 py-1.5 rounded-full text-sm font-medium whitespace-nowrap ${
                  activeSection === section.title
                    ? 'bg-purple-100 text-purple-600'
                    : 'bg-white text-gray-600 border'
                }`}
              >
                {section.title}
              </button>
            ))}
          </div>
        </div>
      </div>

      <div className="p-4 max-w-md mx-auto">
        <div className="space-y-3">
          {filteredItems.map((item, index) => (
            <div
              key={index}
              className="bg-white rounded-lg border cursor-pointer overflow-hidden"
            >
              <div
                className="flex justify-between items-start p-4"
                onClick={() => toggleItem(index)}
              >
                <h3 className="text-base font-medium text-gray-900 pr-4">
                  {item.question}
                </h3>
                <button className="shrink-0 mt-1">
                  {openItems.includes(index) ? (
                    <ChevronUp className="h-4 w-4 text-gray-400" />
                  ) : (
                    <ChevronDown className="h-4 w-4 text-gray-400" />
                  )}
                </button>
              </div>
              {openItems.includes(index) && (
                <div className="px-4 pb-4 text-sm text-gray-600">
                  {item.answer}
                </div>
              )}
            </div>
          ))}
        </div>
      </div>
    </div>
  )
}