'use client'

import {useEffect, useState} from 'react'
import { useRouter } from 'next/navigation'
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar"
import { Button } from "@/components/ui/button"
import { Switch } from "@/components/ui/switch"
import {
  CreditCard,
  User,
  Home,
  Bell,
  Shield,
  Globe,
  Moon,
  Users,
  HelpCircle,
  Lock,
  Info,
  XCircle,
  LogOut,
  ChevronRight,
  Share,
  Receipt, TableOfContents
} from 'lucide-react'
import {useTheme} from "next-themes";

export function BlockPage() {
  const router = useRouter()
  const [darkMode, setDarkMode] = useState(false)
  const { setTheme } = useTheme()
  const navigateTo = (path: string) => {
    router.push(path)
  }
  useEffect(() => {
    if (!darkMode){
      setTheme("light")
    }else {
      setTheme("dark")
    }

  },[darkMode, setTheme])

  return (
    <div className="min-h-screen bg-gray-50">
      <div className="max-w-md mx-auto p-4">
        <div className="bg-white rounded-lg p-4 mb-4 flex items-center justify-between">
          <div className="flex items-center space-x-3">
            <Avatar className="h-12 w-12">
              <AvatarImage src="/placeholder.svg" alt="@user" />
              <AvatarFallback>AD</AvatarFallback>
            </Avatar>
            <div>
              <h2 className="font-semibold">Antoine Dupont</h2>
              <p className="text-sm text-gray-500">antoine.dupont@casaok.fr</p>
            </div>
          </div>
          <Button size="icon" variant="ghost">
            <Share className="h-5 w-5" />
          </Button>
        </div>

        <div className="bg-[#8B5CF6]/10 rounded-lg p-4 mb-6">
          <div className="flex items-center justify-between">
            <span className="font-medium">Inviter des propriétaires</span>
            <Share className="h-5 w-5 text-[#8B5CF6]" />
          </div>
        </div>

        <div className="space-y-6">
          <div>
            <h3 className="text-sm font-medium text-gray-500 mb-2">Général</h3>
            <div className="bg-white rounded-lg divide-y">
              <Button 
                variant="ghost" 
                className="w-full flex items-center justify-between p-4 h-auto"
                onClick={() => navigateTo('/settings/payment-methods')}
              >
                <div className="flex items-center">
                  <CreditCard className="h-5 w-5 mr-3" />
                  <span>Moyens de paiement</span>
                </div>
                <ChevronRight className="h-5 w-5 text-gray-400" />
              </Button>
              <Button 
                variant="ghost" 
                className="w-full flex items-center justify-between p-4 h-auto"
                onClick={() => navigateTo('/settings/personal-info')}
              >
                <div className="flex items-center">
                  <User className="h-5 w-5 mr-3" />
                  <span>Informations personnelles</span>
                </div>
                <ChevronRight className="h-5 w-5 text-gray-400" />
              </Button>
              <Button 
                variant="ghost" 
                className="w-full flex items-center justify-between p-4 h-auto"
                onClick={() => navigateTo('/settings/properties')}
              >
                <div className="flex items-center">
                  <Home className="h-5 w-5 mr-3" />
                  <span>Mes propriétés</span>
                </div>
                <ChevronRight className="h-5 w-5 text-gray-400" />
              </Button>
              <Button 
                variant="ghost" 
                className="w-full flex items-center justify-between p-4 h-auto"
                onClick={() => navigateTo('/settings/notifications')}
              >
                <div className="flex items-center">
                  <Bell className="h-5 w-5 mr-3" />
                  <span>Notifications</span>
                </div>
                <ChevronRight className="h-5 w-5 text-gray-400" />
              </Button>
              <Button 
                variant="ghost" 
                className="w-full flex items-center justify-between p-4 h-auto"
                onClick={() => navigateTo('/settings/security')}
              >
                <div className="flex items-center">
                  <Shield className="h-5 w-5 mr-3" />
                  <span>Sécurité</span>
                </div>
                <ChevronRight className="h-5 w-5 text-gray-400" />
              </Button>
              <Button
                  variant="ghost"
                  className="w-full flex items-center justify-between p-4 h-auto"
                  onClick={() => navigateTo('/settings/billing')}
              >
                <div className="flex items-center">
                  <Receipt className="h-5 w-5 mr-3" />
                  <span>Factures</span>
                </div>
                <ChevronRight className="h-5 w-5 text-gray-400" />
              </Button>
              <Button variant="ghost" className="w-full flex items-center justify-between p-4 h-auto">
                <div className="flex items-center">
                  <Globe className="h-5 w-5 mr-3" />
                  <span>Langue</span>
                </div>
                <div className="flex items-center">
                  <span className="text-sm text-gray-500 mr-2">Français</span>
                  <ChevronRight className="h-5 w-5 text-gray-400" />
                </div>
              </Button>
              <div className="flex items-center justify-between p-4">
                <div className="flex items-center">
                  <Moon className="h-5 w-5 mr-3" />
                  <span>Mode sombre</span>
                </div>
                <Switch
                  checked={darkMode}
                  onCheckedChange={setDarkMode}
                />
              </div>

            </div>
          </div>

          <div>
            <h3 className="text-sm font-medium text-gray-500 mb-2">À propos</h3>
            <div className="bg-white rounded-lg divide-y">
              <Button variant="ghost" className="w-full flex items-center justify-between p-4 h-auto" onClick={() => navigateTo('/help')}>
                <div className="flex items-center">
                  <HelpCircle className="h-5 w-5 mr-3" />
                  <span>Centre d'aide</span>
                </div>
                <ChevronRight className="h-5 w-5 text-gray-400" />
              </Button>
              <Button variant="ghost" className="w-full flex items-center justify-between p-4 h-auto">
                <div className="flex items-center">
                  <Lock className="h-5 w-5 mr-3" />
                  <span>Politique de confidentialité</span>
                </div>
                <ChevronRight className="h-5 w-5 text-gray-400" />
              </Button>
              <Button variant="ghost" className="w-full flex items-center justify-between p-4 h-auto" onClick={() => navigateTo('/about')} >

                <div className="flex items-center">
                  <Info className="h-5 w-5 mr-3" />
                  <span>À propos de CasaOK</span>
                </div>
                <ChevronRight className="h-5 w-5 text-gray-400" />
              </Button>
              <Button variant="ghost" className="w-full flex items-center justify-between p-4 h-auto" onClick={() => navigateTo('/faq')}>
                <div className="flex items-center">
                  <TableOfContents className="h-5 w-5 mr-3" />
                  <span>FAQ</span>
                </div>
                <ChevronRight className="h-5 w-5 text-gray-400" />
              </Button>
              <Button variant="ghost" className="w-full flex items-center justify-between p-4 h-auto text-red-500 hover:text-red-600">
                <div className="flex items-center">
                  <XCircle className="h-5 w-5 mr-3" />
                  <span>Supprimer mon compte</span>
                </div>
                <ChevronRight className="h-5 w-5" />
              </Button>

            </div>
          </div>

          <Button 
            variant="ghost" 
            className="w-full flex items-center justify-center p-4 text-red-500 hover:text-red-600 hover:bg-red-50"
            onClick={() => router.push('/')}
          >
            <LogOut className="h-5 w-5 mr-2" />
            <span>Déconnexion</span>
          </Button>
        </div>
      </div>
    </div>
  )
}