'use client'

import { useState } from 'react'
import { useRouter } from 'next/navigation'
import { Button } from "@/components/ui/button"
import { Card, CardContent } from "@/components/ui/card"
import { ChevronLeft, CreditCard, Plus } from 'lucide-react'

export function BlockPage() {
  const router = useRouter()
  const [paymentMethods, setPaymentMethods] = useState([
    { id: 1, last4: '4242', brand: 'Visa', expMonth: 12, expYear: 2024 },
    { id: 2, last4: '5555', brand: 'Mastercard', expMonth: 6, expYear: 2025 },
  ])

  const addPaymentMethod = () => {
    // Ici, vous ajouteriez la logique pour ajouter un nouveau moyen de paiement
    console.log('Ajouter un nouveau moyen de paiement')
  }

  return (
    <div className="min-h-screen bg-gray-50">
      <div className="max-w-md mx-auto p-4">
        <div className="flex items-center justify-between mb-6">
          <button 
            onClick={() => router.back()}
            className="p-2 hover:bg-gray-100 rounded-full"
          >
            <ChevronLeft className="h-6 w-6" />
          </button>
          <h1 className="text-xl font-bold text-center text-[#8B5CF6]">Moyens de paiement</h1>
          <div className="w-10" />
        </div>

        <div className="space-y-4">
          {paymentMethods.map((method) => (
            <Card key={method.id} className="bg-white">
              <CardContent className="p-4 flex items-center justify-between">
                <div className="flex items-center">
                  <CreditCard className="h-6 w-6 mr-3 text-[#8B5CF6]" />
                  <div>
                    <p className="font-medium">{method.brand} •••• {method.last4}</p>
                    <p className="text-sm text-gray-500">Expire {method.expMonth}/{method.expYear}</p>
                  </div>
                </div>
                <Button variant="ghost" size="sm">Modifier</Button>
              </CardContent>
            </Card>
          ))}

          <Button 
            onClick={addPaymentMethod}
            className="w-full flex items-center justify-center bg-[#8B5CF6] hover:bg-[#7C3AED] text-white"
          >
            <Plus className="h-5 w-5 mr-2" />
            Ajouter un moyen de paiement
          </Button>
        </div>
      </div>
    </div>
  )
}