'use client'

import { useState } from 'react'
import { ChevronLeft, ChevronRight, Search, MessageCircle, Phone, Mail, FileQuestion, Settings, HelpCircle, MessageSquare, PhoneIcon as WhatsappIcon } from 'lucide-react'
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Input } from "@/components/ui/input"
import Link from 'next/link'

function BottomSheet({ isOpen, onClose, title, children }) {
  if (!isOpen) return null;
  return (
    <div className="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-end justify-center animate-fade-in">
      <div className="bg-white rounded-t-2xl w-full max-h-[90vh] overflow-y-auto animate-slide-up">
        <div className="sticky top-0 bg-white border-b px-4 py-3 flex flex-col items-center">
          <div className="w-12 h-1 bg-gray-300 rounded-full mb-3" />
          <h3 className="text-lg font-semibold">{title}</h3>
          <button 
            onClick={onClose} 
            className="absolute right-4 top-4 p-1 rounded-full hover:bg-gray-100"
          >
            <ChevronLeft className="h-5 w-5 text-gray-500" />
          </button>
        </div>
        <div className="p-4">
          {children}
        </div>
      </div>
    </div>
  );
}

export function BlockPage() {
  const [activePopup, setActivePopup] = useState(null);

  const supportSections = [
    { title: "FAQ", icon: FileQuestion, id: "faq" },
    { title: "Paramètres du compte", icon: Settings, id: "account" },
    { title: "Utilisation de l'app", icon: HelpCircle, id: "usage" },
    { title: "Contacter le support", icon: MessageCircle, id: "contact" },
  ];

  const popupContent = {
    faq: {
      title: "FAQ",
      content: (
        <div className="space-y-4">
          <h4 className="font-semibold text-lg">Questions fréquemment posées</h4>
          <div className="space-y-2">
            <p className="font-medium">Comment réinitialiser mon mot de passe ?</p>
            <p className="text-gray-600">Allez sur l'écran de connexion et cliquez sur "Mot de passe oublié". Suivez les instructions envoyées par e-mail.</p>
          </div>
          <div className="space-y-2">
            <p className="font-medium">Comment ajouter un nouveau bien ?</p>
            <p className="text-gray-600">Dans le menu principal, sélectionnez "Mes biens" puis cliquez sur le bouton "+". Remplissez les détails du bien et sauvegardez.</p>
          </div>
          <div className="space-y-2">
            <p className="font-medium">Comment programmer une inspection ?</p>
            <p className="text-gray-600">Allez dans la section "Inspections", cliquez sur "Nouvelle inspection", sélectionnez le bien et choisissez une date et une heure.</p>
          </div>
        </div>
      )
    },
    account: {
      title: "Paramètres du compte",
      content: (
        <div className="space-y-4">
          <h4 className="font-semibold text-lg">Gestion de votre compte</h4>
          <div className="space-y-2">
            <p className="font-medium">Modifier vos informations personnelles</p>
            <p className="text-gray-600">Allez dans "Paramètres" {'>'} "Profil" pour mettre à jour vos coordonnées.</p>
          </div>
          <div className="space-y-2">
            <p className="font-medium">Changer votre mot de passe</p>
            <p className="text-gray-600">Dans "Paramètres" {'>'} "Sécurité", vous pouvez modifier votre mot de passe.</p>
          </div>
          <div className="space-y-2">
            <p className="font-medium">Gérer vos notifications</p>
            <p className="text-gray-600">Personnalisez vos préférences de notification dans "Paramètres" {'>'} "Notifications".</p>
          </div>
        </div>
      )
    },
    usage: {
      title: "Utilisation de l'app",
      content: (
        <div className="space-y-4">
          <h4 className="font-semibold text-lg">Guide d'utilisation rapide</h4>
          <div className="space-y-2">
            <p className="font-medium">Navigation dans l'app</p>
            <p className="text-gray-600">Utilisez le menu en bas de l'écran pour accéder aux différentes sections : Tableau de bord, Biens, Inspections, et Profil.</p>
          </div>
          <div className="space-y-2">
            <p className="font-medium">Gestion des biens</p>
            <p className="text-gray-600">Dans la section "Biens", vous pouvez ajouter, modifier et supprimer vos propriétés.</p>
          </div>
          <div className="space-y-2">
            <p className="font-medium">Suivi des inspections</p>
            <p className="text-gray-600">La section "Inspections" vous permet de planifier et de suivre toutes vos inspections immobilières.</p>
          </div>
        </div>
      )
    },
    contact: {
      title: "Contacter le support",
      content: (
        <div className="space-y-4">
          <h4 className="font-semibold text-lg">Nous sommes là pour vous aider</h4>
          <div className="space-y-2">
            <p className="font-medium">Par chat</p>
            <p className="text-gray-600">Utilisez notre chat en direct pour une assistance immédiate du lundi au vendredi, de 9h à 18h.</p>
            <Button className="w-full bg-purple-600 text-white hover:bg-purple-700">Démarrer un chat</Button>
          </div>
          <div className="space-y-2">
            <p className="font-medium">Par téléphone</p>
            <p className="text-gray-600">Appelez-nous au 01 23 45 67 89 du lundi au vendredi, de 9h à 18h.</p>
            <Button className="w-full bg-purple-600 text-white hover:bg-purple-700">Appeler le support</Button>
          </div>
          <div className="space-y-2">
            <p className="font-medium">Par WhatsApp</p>
            <p className="text-gray-600">Envoyez-nous un message WhatsApp au +33 6 12 34 56 78 pour une réponse rapide.</p>
            <Button className="w-full bg-purple-600 text-white hover:bg-purple-700">Contacter sur WhatsApp</Button>
          </div>
          <div className="space-y-2">
            <p className="font-medium">Par e-mail</p>
            <p className="text-gray-600">Envoyez-nous un e-mail à support@casaok.com. Nous répondrons dans les 24 heures ouvrables.</p>
            <Button className="w-full bg-purple-600 text-white hover:bg-purple-700">Envoyer un e-mail</Button>
          </div>
        </div>
      )
    },
  };

  return (
    <div className="flex flex-col min-h-screen bg-gray-100">
      <header className="sticky top-0 z-10 bg-white border-b">
        <div className="flex items-center justify-between px-4 py-3">
          <Link href="/">
            <Button variant="ghost" size="icon">
              <ChevronLeft className="h-6 w-6" />
            </Button>
          </Link>
          <h1 className="text-base font-semibold">Aide et Support</h1>
          <div className="w-10"></div>
        </div>
      </header>

      <main className="flex-1 overflow-y-auto p-3 space-y-3">
        <Card>
          <CardContent className="pt-6">
            <div className="relative">
              <Search className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400" />
              <Input type="search" placeholder="Rechercher de l'aide" className="pl-10" />
            </div>
          </CardContent>
        </Card>

        <Card>
          <CardHeader className="pb-2">
            <CardTitle className="text-lg">Comment pouvons-nous vous aider ?</CardTitle>
          </CardHeader>
          <CardContent className="pt-0">
            <div className="grid grid-cols-2 gap-3">
              {supportSections.map((section) => (
                <button
                  key={section.id}
                  className="flex flex-col items-center justify-center p-4 bg-white rounded-lg border hover:bg-gray-50 transition-colors"
                  onClick={() => setActivePopup(section.id)}
                >
                  <section.icon className="h-8 w-8 text-purple-600 mb-2" />
                  <span className="text-sm font-medium text-center">{section.title}</span>
                </button>
              ))}
            </div>
          </CardContent>
        </Card>

        <Card>
          <CardHeader className="pb-2">
            <CardTitle className="text-lg">Contactez-nous</CardTitle>
          </CardHeader>
          <CardContent className="pt-0 space-y-4">
            <div className="flex items-center space-x-3">
              <Phone className="h-5 w-5 text-purple-600" />
              <span className="text-sm">01 23 45 67 89</span>
            </div>
            <div className="flex items-center space-x-3">
              <Mail className="h-5 w-5 text-purple-600" />
              <span className="text-sm">support@casaok.com</span>
            </div>
            <div className="flex items-center space-x-3">
              <WhatsappIcon className="h-5 w-5 text-purple-600" />
              <span className="text-sm">+33 6 12 34 56 78</span>
            </div>
          </CardContent>
        </Card>
      </main>

      <BottomSheet
        isOpen={!!activePopup}
        onClose={() => setActivePopup(null)}
        title={activePopup ? popupContent[activePopup].title : ''}
      >
        {activePopup && popupContent[activePopup].content}
      </BottomSheet>

      <footer className="bg-white border-t py-3 px-4 text-center text-xs text-gray-500">
        <p>Besoin d'aide supplémentaire ? <a href="#" className="text-purple-600 underline">Visitez notre centre d'aide</a></p>
      </footer>
    </div>
  )
}