'use client'

import { useEffect, useState } from 'react'
import { motion } from 'framer-motion'
import Confetti from 'react-confetti'
import { useRouter } from 'next/navigation'
import { Button } from "@/components/ui/button"
import { Home, CheckCircle2 } from 'lucide-react'

const CreatePropertySuccess = () => {
  const [windowSize, setWindowSize] = useState({ width: 0, height: 0 })
  const router = useRouter()

  useEffect(() => {
    const handleResize = () => {
      setWindowSize({
        width: window.innerWidth,
        height: window.innerHeight,
      })
    }

    // Set initial size
    handleResize()

    // Add event listener
    window.addEventListener('resize', handleResize)

    // Remove event listener on cleanup
    return () => window.removeEventListener('resize', handleResize)
  }, [])

  const handleReturnHome = () => {
    router.push('/dashboard')
  }

  return (
    <div className="flex flex-col items-center justify-center min-h-screen bg-white p-4">
      <Confetti
        width={windowSize.width}
        height={windowSize.height}
        recycle={false}
        numberOfPieces={200}
      />
      <motion.div
        initial={{ scale: 0.8, opacity: 0 }}
        animate={{ scale: 1, opacity: 1 }}
        transition={{ duration: 0.5 }}
        className="text-center max-w-md w-full"
      >
        <motion.div
          initial={{ y: -20 }}
          animate={{ y: 0 }}
          transition={{ duration: 0.5, delay: 0.2 }}
        >
          <CheckCircle2 className="w-16 h-16 text-[#8B5CF6] mx-auto mb-6" />
        </motion.div>
        <h1 className="text-2xl font-bold text-[#1F2937] mb-4">Demande envoyée avec succès !</h1>
        <p className="text-base text-[#4B5563] mb-8">
          Votre demande d'inspection va bientôt être traitée. Nous vous contacterons sous peu.
        </p>
        <div className="flex justify-center">
          <Button
            onClick={handleReturnHome}
            className="bg-[#8B5CF6] hover:bg-[#7C3AED] text-white font-medium py-2 px-4 rounded-lg transition-colors duration-200 flex items-center justify-center"
          >
            <Home className="mr-2 h-4 w-4" />
            Retour à l'accueil
          </Button>
        </div>
      </motion.div>
    </div>
  )
}

export default CreatePropertySuccess